--============================================================== MODIFICACION DE NOMBRE DE UNA TABLA ==========================================================
-- 1) Si existe un _ para la anterior; creamos el _ para la nueva 
IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CFU_Cliente_SCA_QR_Generar_') 
                   and type = 'FN')
BEGIN

	IF NOT EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CFJ_SCA_QR_Dinamico_Generar_') 
                   and type = 'FN')
	BEGIN
		-- Se Obtiene la definición de la función existente
		DECLARE @definicion VARCHAR(MAX);
		SELECT @definicion = REPLACE(OBJECT_DEFINITION(OBJECT_ID('CFU_Cliente_SCA_QR_Generar_')), 'CFU_Cliente_SCA_QR_Generar_', 'CFJ_SCA_QR_Dinamico_Generar_');

		-- Crea la nueva función con la definición modificada
		EXEC(@definicion);
	END
	
	-- Dropeamos la función 
    DROP FUNCTION dbo.CFU_Cliente_SCA_QR_Generar_
END
GO


-- 2) Eliminamos la funcion anterior
IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CFU_Cliente_SCA_QR_Generar') 
                   and type = 'FN')

BEGIN
	
    DROP FUNCTION dbo.CFU_Cliente_SCA_QR_Generar
END
GO

-- 3) Creamos la funcion con el nuevo nombre
IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CFJ_SCA_QR_Dinamico_Generar') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CFJ_SCA_QR_Dinamico_Generar
END
GO

CREATE FUNCTION [dbo].[CFJ_SCA_QR_Dinamico_Generar](@pJson VARCHAR(8000))
RETURNS VARCHAR(2048)
AS
BEGIN
DECLARE @Json_Respuesta		VARCHAR(8000)

/*Variables recibidas por parametro a traves del JSON*/
DECLARE @pId_Cliente		INT
DECLARE @pId_Producto		VARCHAR(14)
DECLARE @pFecha_Desde		DATETIME
DECLARE @pFecha_Hasta		DATETIME
DECLARE @pId_Lista_Precio	SMALLINT
DECLARE @pToken				VARCHAR(256)
DECLARE @pApp				VARCHAR(256) --App:CleverSCA
DECLARE @pFormato			VARCHAR(1)

SET @pId_Cliente		= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Cliente')), 0)
SET @pId_Producto		= UPPER(LTRIM(RTRIM(ISNULL(CONVERT(VARCHAR(14), dbo.CF_JSON_VALUE(@pJson,'Id_Producto')), ''))))
SET @pFecha_Desde		= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Desde')), '19000101')
SET @pFecha_Hasta		= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Hasta')), '19000101')
SET @pId_Lista_Precio	= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Lista_Precio')), 0)
SET @pToken				= LTRIM(RTRIM(ISNULL(CONVERT(VARCHAR(256), dbo.CF_JSON_VALUE(@pJson,'Token')), '')))
SET @pFormato			= ISNULL(CONVERT(VARCHAR(1), dbo.CF_JSON_VALUE(@pJson,'Formato')), 'A')
/*FIN Variables recibidas por parametro a traves del JSON*/


/*Variables locales*/
DECLARE @Respuesta				VARCHAR(8000) 
DECLARE @Token					VARCHAR(256)
DECLARE @Flag_Existe_Token		TINYINT
DECLARE @url					VARCHAR(2048)
DECLARE @cant_usos_permitidos	INT
DECLARE @fecha_desde			DATETIME
DECLARE @fecha_hasta			DATETIME
/*FIN Variables locales*/

--===========================================================================================

IF(dbo.CF_xParam('QR_Dinamico') = 1)
BEGIN

	IF EXISTS ( SELECT * FROM sysobjects WHERE id = object_id(N'dbo.CFJ_SCA_QR_Dinamico_Generar_') AND type = 'FN')
	BEGIN
		SET @Respuesta = (dbo.CFJ_SCA_QR_Dinamico_Generar_(@pJson))
		RETURN ISNULL(@Respuesta, '')
	END


--===========================================================================================

-------------------------------------------------------------------------------------------------------------------------------------
/*
VERSIONES:
02/08/2022 Se agrega parametro @pFormato
*/
-------------------------------------------------------------------------------------------------------------------------------------

IF(@pFormato = 'A')
BEGIN
	SET @url = (dbo.CF_xParam('API_Url'))

	SET @url = @url + 'index.php'

	SET @url = @url + '?acs_qr=1'

	IF(@pToken = '')
	BEGIN		
		--SET @Token = (dbo.CF_Token(32))
		SET @Token = (dbo.CF_Clientes_Links_Token('A',32))	
	END
	ELSE
	BEGIN
		SET @Token = @pToken
	END

	SET @url = @url + '&token=' + @Token

	IF(@pId_Producto <> '')
	BEGIN
		SET @url = @url + '&id_producto=' + @pId_Producto
	END

	IF(@pId_Lista_Precio > 0)
	BEGIN
		SET @url = @url + '&id_lista_precio=' + @pId_Lista_Precio
	END
END

IF(@pFormato = 'N')
BEGIN
	SET @Token = dbo.CF_Clientes_Links_Token(@pFormato, 10)
	
	SET @url	= @Token
END

-------------------------------------------------------------------------------------------------------------------

IF(@pFecha_Desde > '19000101' AND @pFecha_Hasta > '19000101')
BEGIN
	SET @fecha_desde = @pFecha_Desde
	SET @fecha_hasta = @pFecha_Hasta
END
ELSE
BEGIN
	SET @fecha_desde = GETDATE()
	SET @fecha_hasta = DATEADD(MINUTE, 3, GETDATE())
END

-------------------------------------------------------------------------------------------------------------------

SET @cant_usos_permitidos = 1

-------------------------------------------------------------------------------------------------------------------

	SET @Json_Respuesta =	'{' +
							dbo.CF_Json_ParsearVariable('url', @url, 'VARCHAR(2048)') + ',' +
							dbo.CF_Json_ParsearVariable('token', @token, 'VARCHAR(256)') + ',' + 
							dbo.CF_Json_ParsearVariable('cant_usos_permitidos', @cant_usos_permitidos, 'INT') + ',' + 
							dbo.CF_Json_ParsearVariable('fecha_desde', @fecha_desde, 'DATETIME') + ',' + 
							dbo.CF_Json_ParsearVariable('fecha_hasta', @fecha_hasta, 'DATETIME') + 
							'}'
END
	RETURN ISNULL(@Json_Respuesta, '')
END

--SELECT dbo.CFU_Cliente_SCA_QR_Generar('{"id_cliente":"898612"}')
--SELECT dbo.CFU_Cliente_SCA_QR_Generar('{"id_cliente":"898612","Formato":"N"}')